/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file SplineInterpTool.h
 * @brief MGSplineInterpTool NX̃C^[tFCX
 */
#ifndef _MGSplineGen_HH_
#define _MGSplineGen_HH_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/LBRepEndC.h"
#include "Calc/curve.h"

/// @class MGSplineInterpTool SplineInterpTool.h "CurveCmd/SplineInterpTool.h"
///
/// ԓ_wɂXvCR}h
class MGSplineInterpTool : public MGLocateState{
public:
	explicit MGSplineInterpTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	bool get_curve(const std::vector<MGPosition>& ip);
	void prompt_message() const;

	std::unique_ptr<MGCurve> m_curve; ///< ꎞ`p
	UINT m_nIDS; ///< error message

	int m_nDegree; ///< Ȑ̎ (== order - 1)
	bool m_1stDerivS;///<indicates if 1st derivative is allowed to input for the start point.
	MGLBRepEndC m_cndStart; ///< Ȑ̎n_ɂڐ (optional)
	MGLocateInfo m_linfo;///<to store the end point's MGLocateinfo.
	bool m_1stDerivE;///<indicates if 1st derivative is allowed to input for the end point.
	MGLBRepEndC m_cndEnd; ///< Ȑ̏I_ɂڐ (optional)
	bool m_bClose; ///< Ȑ邩ǂ
	bool m_bSharp; ///< Ȑ̂ł΁AnI_̓LNɂ邩
};

#endif
