/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file RectCorner.h
 * @brief MGRectCornerTool NX̃C^[tFCX
 */
#if !defined(AFX_RECTCORNER_H__D53ACEB8_A61F_47F8_B626_5815B10B3792__INCLUDED_)
#define AFX_RECTCORNER_H__D53ACEB8_A61F_47F8_B626_5815B10B3792__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "Calc/rect.h"

class MGCommandStateOwner;

/// class MGRectCornerTool RectCorner.h "CurveCmd/RectCorner.h"
///
/// Creates a rectangle from two corner points.
class MGRectCornerTool : public MGLocateState{
public:
	explicit MGRectCornerTool(MGCommandStateOwner* owner);
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	bool calculate(const MGPosition& posLast);
	void prompt_message() const;

	mgcalc::MGRect m_rect; ///< ꎞ`p
	mgcalc::MGRoundRect m_round_rect; ///< ꎞ`p

	UINT m_nIDS; ///< error message
	double m_dRadius; ///< EhR[i[̔a
	bool m_bRound; ///< `̊pۂ邩
};

#endif // !defined(AFX_RECTCORNER_H__D53ACEB8_A61F_47F8_B626_5815B10B3792__INCLUDED_)
