/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file PolylineTool.h
 * @brief MGPolylineTool NX̃C^[tFCX
 */
#if !defined(AFX_POLYLINETOOL_H__61C4A89D_1AAF_4531_AFBD_F5AA1F1612D1__INCLUDED_)
#define AFX_POLYLINETOOL_H__61C4A89D_1AAF_4531_AFBD_F5AA1F1612D1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGPolylineTool PolylineTool.h "CurveCmd/PolylineTool.h"
///
/// Creates a polyline.
class MGPolylineTool : public MGLocateState{
public:
	explicit MGPolylineTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	bool calculate();
	void prompt_message() const;

	UINT m_nIDS; ///< error message
	bool m_bClose; ///< n_ƏI_ԃIvV
};

#endif // !defined(AFX_POLYLINETOOL_H__61C4A89D_1AAF_4531_AFBD_F5AA1F1612D1__INCLUDED_)
