/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file PolylineTool.cpp
 * @brief MGPolylineTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "CurveCmd/PolylineTool.h"
#include "mg/LBRep.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGPolylineTool

MGPolylineTool::MGPolylineTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_POLYLINE,LINE_RUBBER,POINTLINE_IPDRAW),
m_nIDS(1), m_bClose(false){
}

MGCommandBase* MGPolylineTool::initial_clone(fugenDoc* pDoc)const{
	return new MGPolylineTool(pDoc);
}

bool MGPolylineTool::initiate_tool(){
	MGLocateState::initiate_tool();
	setDrawerColorLine(MGColor::get_instance(MGColor::SpringGreen));
	return false;
}

bool MGPolylineTool::calculate(){
	const LInfoVec& linfos=locates();
	if(linfos.size() < 2){
		// LZƂ݂Ȃ
		return false;
	}

	// IuWFNg
	std::vector<MGPosition> ipos;
	extract_points_world(linfos,ipos);
	if(m_bClose){
		// n_ƏI_ԕ邽
		ipos.push_back(linfos.front()->point_world());
	}
	MGBPointSeq bp(ipos);

	// hLgύX
	MGLBRep* lb=new MGLBRep;
	lb->buildByInterpolation(bp, 2);
	add_object_to_current_group(lb);	
	return true;
}

bool MGPolylineTool::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	size_t n = locates().size();
	switch(nChar){
	case 'c':
	case 'C':
		// n_ƏI_ԃIvVł邪
		// Ƀ|Č`󂪌ƂȂ
		if(n>=3)
			m_bClose = true;//TO Process VK_RETURN.
		break;
	case VK_RETURN:
		if(!calculate()){
			return OnCommandEnd(m_nIDS);
		}
		return OnCommandEnd(1);
	default:;
	}
	return MGLocateState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}

bool MGPolylineTool::OnLocated(const MGLocateInfo&){
	return false;
}

void MGPolylineTool::prompt_message() const{
	UINT id;
	switch(locates().size()){
	case 0:
		id=IDS_PROMPT_POLYLINE_START;
		break;
	case 1:
	case 2:
		id=IDS_PROMPT_POLYLINE;
		break;
	default:
		id=IDS_PROMPT_POLYLINE_C;
		break;
	}
	SetStatusMessage(id);
}
