/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file PolygonStar.h
 * @brief MGPolygonStarTool NX̃C^[tFCX
 */
#if !defined(AFX_POLYGONSTAR_H__E83C2F86_E5C7_413B_AD3E_EAD38ABDAE4C__INCLUDED_)
#define AFX_POLYGONSTAR_H__E83C2F86_E5C7_413B_AD3E_EAD38ABDAE4C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Curve.h"

/// @class MGPolygonStarTool PolygonStar.h "CurveCmd/PolygonStar.h"
///
/// ^p`𐶐R}h
class MGPolygonStarTool : public MGLocateState{
public:
	explicit MGPolygonStarTool(MGCommandStateOwner* owner);
	explicit MGPolygonStarTool(fugenDoc* pDoc);
	MGPolygonStarTool* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	int m_VertexNum; ///< ^̒_̔

	MGVector m_normal;///<normal of the plane on which the star polygon lies.
			///The plane is defined by m_normal*(P1-P0), where P0 and P1 are
			///the 1st and 2nd input points. P0 is the center of the star shape.
			
	bool m_bVertical; ///< CPlaneɐȖʂʂ悤ɂ邩
};

#endif // !defined(AFX_POLYGONSTAR_H__E83C2F86_E5C7_413B_AD3E_EAD38ABDAE4C__INCLUDED_)
