/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file PointMultiTool.cpp
 * @brief MGPointMultiTool NX̃Cve[V
 */

#include "stdafx.h"
#include "mg/Point.h"
#include "Calc/mgcalc.h"
#include "Calc/mgfunctor.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "CurveCmd/PointMultiTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGPointMultiTool

MGPointMultiTool::MGPointMultiTool(fugenDoc* pDoc)
:MGLocateState(pDoc,ID_CURVE_POINT_MULTI,NO_RUBBER,POINT_IPDRAW){}

MGCommandBase* MGPointMultiTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGPointMultiTool(pDoc);
}

bool MGPointMultiTool::initiate_tool(){
	MGLocateState::initiate_tool();
	setDrawerColorPoint(MGColor::get_instance(MGColor::SpringGreen));
	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_POINT_MULTI);
	return false;
}

// _DȂ͂ă^[L[ȂǂƂĂ΂邱ƂɂȂ
bool MGPointMultiTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	const LInfoVec& linfos=locates();
	UINT rid = 3;// empty̎LZƂ݂Ȃ
	if(!linfos.empty()){
		std::list<MGPoint*> tmp;
		for(auto& linf:linfos)
			tmp.push_back(new MGPoint(linf->point_world()));		
		addGelsToCurrentGroup(tmp.begin(), tmp.end());
		// ĐI
		rid = nIDS;
	}
	return MGLocateState::OnCommandEnd(rid);
}

bool MGPointMultiTool::OnLocated(const MGLocateInfo&){
	// Cӂ̌_ǉł
	return false;
}
