/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file PointClosestTool.h
 * @brief MGPointClosestTool NX̃C^[tFCX
 */
#if !defined(AFX_CLOSESTTOOL_H__17FFBE4F_3DD2_47F0_8D5C_390909D0BA85__INCLUDED_)
#define AFX_CLOSESTTOOL_H__17FFBE4F_3DD2_47F0_8D5C_390909D0BA85__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

/// @class MGPointClosestTool PointClosestTool.h "CurveCmd/PointClosestTool.h"
///
/// Finds the closest point of an object (as yet a point), and
/// creates a point there.
class MGPointClosestTool : public MGCommandStateOwner{
public:
	explicit MGPointClosestTool(
		fugenDoc* pDoc	//the document
	);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	bool make_model();

	MGPickObjects m_curve;//Curve to evaluate the closest point.

	friend class MGPointClosestToolSCurve;
	friend class MGPointClosestToolIPoint;
};

//curve selection class.
class MGPointClosestToolSCurve : public MGSelectState{
public:
	MGPointClosestToolSCurve(MGPointClosestTool* owner);
	MGPointClosestTool* state_owner(){
		return static_cast<MGPointClosestTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
};


class MGPointClosestToolIPoint : public MGLocateState{
public:
	MGPointClosestToolIPoint(MGPointClosestTool* owner);
	MGPointClosestTool* state_owner(){
		return static_cast<MGPointClosestTool*>(get_owner_command());
	}
	
	virtual bool initiate_tool();
	virtual bool OnLocated(
		const MGLocateInfo& linfo
	);
};

#endif // !defined(AFX_CLOSESTTOOL_H__17FFBE4F_3DD2_47F0_8D5C_390909D0BA85__INCLUDED_)
