/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file Parabola.h
 * @brief MGParabolaTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEPARABOLA_H__5F8B4405_B4AA_441A_A2B9_CCB9C555ECAC__INCLUDED_)
#define AFX_CURVEPARABOLA_H__5F8B4405_B4AA_441A_A2B9_CCB9C555ECAC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Curve.h"

/// @class MGParabolaTool Parabola.h CurveCmd/Parabola.h
///
/// _ƕAI_^ĕ𐶐
class MGParabolaTool : public MGLocateState{
public:
	explicit MGParabolaTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);

	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	void prompt_message() const;
	
	std::unique_ptr<MGCurve> m_parabola; ///< ꎞ`pIuWFNg
	UINT m_nIDS; ///< G[bZ[W
	bool m_bHalf; ///< ͕Б邩ǂ
};

#endif // !defined(AFX_CURVEPARABOLA_H__5F8B4405_B4AA_441A_A2B9_CCB9C555ECAC__INCLUDED_)
