/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file LineVertical.h
 * @brief MGLineVerticalTool NX̃C^[tFCX
 */
#if !defined(AFX_LINEVERTICAL_H__198386A5_043B_4DA8_8806_D210D921E97C__INCLUDED_)
#define AFX_LINEVERTICAL_H__198386A5_043B_4DA8_8806_D210D921E97C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLineVerticalTool LineVertical.h "CurveCmd/LineVertical.h"
///
/// Creates a line vertical to the construction plane.
class MGLineVerticalTool : public MGLocateState{
public:
	explicit MGLineVerticalTool(fugenDoc* pDoc);
	explicit MGLineVerticalTool(MGCommandStateOwner* owner);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

	// To draw temporal pictures this is overridden.
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	bool m_bBoth; // IvV
};
#endif // !defined(AFX_LINEVERTICAL_H__198386A5_043B_4DA8_8806_D210D921E97C__INCLUDED_)
