/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file LineTan1Tool.h
 * @brief MGLineTan1Tool NX̃C^[tFCX
 */
#if !defined(AFX_LINETAN1TOOL_H__D6B15A65_507F_485C_8171_830652BEC7CE__INCLUDED_)
#define AFX_LINETAN1TOOL_H__D6B15A65_507F_485C_8171_830652BEC7CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLineTan1Tool LineTan1Tool.h "CurveCmd/LineTan1Tool.h"
///
/// Creates a line tangent from a curve.
class MGLineTan1Tool : public MGLocateState{
public:
	explicit MGLineTan1Tool(fugenDoc* pDoc);
	explicit MGLineTan1Tool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	void prompt_message() const;

	const MGCurve* m_curve;  ///< ڐƂ邽߂̋Ȑ
	double         m_param;  ///< ڐƂȐ̃sbNʒup[^

	std::unique_ptr<MGCurve>  m_line; ///< ꎞ`p
	
	// eIvV
	// Ȃ݂ɁA̓R}hIĂLȂ
	bool m_bBoth          : 1;  ///< 1_ڂ̓͂̈Ӗ (true _; false n_)
};

#endif // !defined(AFX_LINETAN1TOOL_H__D6B15A65_507F_485C_8171_830652BEC7CE__INCLUDED_)
