/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file LineSegmentTool.h
 * @brief MGLineSegmentTool NX̃C^[tFCX
 */
#if !defined(AFX_LINESEGMENTTOOL_H__B0FDFF96_0F63_4B70_8C27_81B679BBF5E1__INCLUDED_)
#define AFX_LINESEGMENTTOOL_H__B0FDFF96_0F63_4B70_8C27_81B679BBF5E1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"

/// @class MGLineGeneralTool LineSegmentTool.h "CurveCmd/LineSegmentTool.h"
///
/// eR}h̃^[~iIR}h
class MGLineGeneralTool : public MGCommandStateOwner{
public:
	explicit MGLineGeneralTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
};

/// @class MGLineSingleTool LineSegmentTool.h "CurveCmd/LineSegmentTool.h"
///
/// nR}hōłPȂ̂łB
class MGLineSingleTool : public MGLocateState{
public:
	explicit MGLineSingleTool(fugenDoc* pDoc);
	explicit MGLineSingleTool(MGLineGeneralTool* owner);
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& linfo);

private:
	void prompt_message() const;
	
	bool m_bBoth; ///< 𗼕ɍ邩ǂ
	              ///< (ŏ͎̓͂n_ł͂ȂĒ_)
};

/// @class MGLineSegmentTool LineSegmentTool.h "CurveCmd/LineSegmentTool.h"
///
/// Creates multiple lines.
class MGLineSegmentTool : public MGLocateState{
public:
	explicit MGLineSegmentTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	//Initiate the class.
	//Overrided initiate must invoke initiate_tool first.
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo&);

private:
	bool calculate();
	void prompt_message() const;

	bool m_bClose; ///< Ō̓_ƍŏ̓_Ԑ𐶐邩ǂ
};

#endif // !defined(AFX_LINESEGMENTTOOL_H__B0FDFF96_0F63_4B70_8C27_81B679BBF5E1__INCLUDED_)
