/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file LinePerp2Tool.h
 * @brief MGLinePerp2Tool NX̃C^[tFCX
 */
#if !defined(AFX_LINEPERP2TOOL_H__C55BDD2E_5BB0_410F_AEBB_21B0AB931A75__INCLUDED_)
#define AFX_LINEPERP2TOOL_H__C55BDD2E_5BB0_410F_AEBB_21B0AB931A75__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLinePerp2Tool LinePerp2Tool.h "CurveCmd/LinePerp2Tool.h"
///
/// Creates a line perpendicular to two curves.
class MGLinePerp2Tool : public MGLocateState{
public:
	explicit MGLinePerp2Tool(fugenDoc* pDoc);
	explicit MGLinePerp2Tool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;

};

#endif // !defined(AFX_LINEPERP2TOOL_H__C55BDD2E_5BB0_410F_AEBB_21B0AB931A75__INCLUDED_)
