/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file LinePerp1Tool.h
 * @brief MGLinePerp1Tool NX̃C^[tFCX
 */
#if !defined(AFX_LINEPERP1TOOL_H__B8E3A376_C1ED_4AE7_AA4B_94F0D3D7405F__INCLUDED_)
#define AFX_LINEPERP1TOOL_H__B8E3A376_C1ED_4AE7_AA4B_94F0D3D7405F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateOnOBjects.h"

class MGStraight;

/// @class MGLinePerp1Tool LinePerp1Tool.h "CurveCmd/LinePerp1Tool.h"
///
/// Creates a line perpendicular from a curve.
class MGLinePerp1Tool : public MGLocateState{
public:
	explicit MGLinePerp1Tool(fugenDoc* pDoc);
	explicit MGLinePerp1Tool(MGCommandStateOwner* owner);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	void fix_start_pos();

	// m_line, m_line_t XV
	void update_lines(const MGPosition& Plast);
	
	const MGCurve* m_curve; ///< Ƃ邽߂̋Ȑ
	double         m_param; ///< ƂȐ̃sbNʒup[^

	std::unique_ptr<MGCurve>  m_line; ///< ꎞ`p
	std::unique_ptr<MGCurve>  m_line_t; ///< ꎞ`p (ڐ)
	std::unique_ptr<MGStraight> m_line_fix;
	// _t ƂvtBNX tangent ̓Ă݂

	// eIvV
	// Ȃ݂ɁA̓R}hIĂLȂ
	bool m_bBoth          : 1; ///< 1_ڂ̓͂̈Ӗ (true _; false n_)
};

#endif // !defined(AFX_LINEPERP1TOOL_H__B8E3A376_C1ED_4AE7_AA4B_94F0D3D7405F__INCLUDED_)
