/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file LineExtend.h
 * @brief MGLineExtendTool NX̃C^[tFCX
 */
#if !defined(AFX_LINEEXTEND_H__30681DA4_C8D5_455E_9499_1F862268BCF8__INCLUDED_)
#define AFX_LINEEXTEND_H__30681DA4_C8D5_455E_9499_1F862268BCF8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLineExtendTool LineExtend.h "CurveCmd/LineExtend.h"
///
/// R}h́uvIvVI
///  state \NXB
class MGLineExtendTool : public MGLocateState
{
	UINT m_nIDS; ///< error message

	const MGCurve* m_curve;
	double m_param;

	// IvV
	bool m_bBoth; ///< [_𐶐̎n_ł͂Ȃ_Ƃ邩ǂ
	bool m_bEnd; ///< X̒[_Xibv on/off 

public:
	// \ŃJgR}hƂėpꍇ ctor
	explicit MGLineExtendTool(fugenDoc* pDoc);

	// R}h E L[ŌĂԏꍇ ctor
	explicit MGLineExtendTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	std::unique_ptr<MGCurve> create_line(const MGPosition& epos) const;
};

#endif // !defined(AFX_LINEEXTEND_H__30681DA4_C8D5_455E_9499_1F862268BCF8__INCLUDED_)
