/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file LineBisect.h
 * @brief MGLineBisectTool NX̃C^[tFCX
 */
#if !defined(AFX_LINEBISECT_H__274AB43C_8F30_4BED_ADD5_EE9DFE328C66__INCLUDED_)
#define AFX_LINEBISECT_H__274AB43C_8F30_4BED_ADD5_EE9DFE328C66__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLineBisectTool LineBisect.h "CurveCmd/LineBisect.h"
///
/// Creates a line that bisects two lines.
class MGLineBisectTool : public MGLocateState{
public:
	explicit MGLineBisectTool(fugenDoc* pDoc);
	explicit MGLineBisectTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate(fugenView* pView);
	void prompt_message() const;
	
	UINT m_nIDS;  ///< error message
	bool m_bBoth; ///< IvV
};

#endif // !defined(AFX_LINEBISECT_H__274AB43C_8F30_4BED_ADD5_EE9DFE328C66__INCLUDED_)
