/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file Line4Point.h
 * @brief MGLine4PointTool NX̃C^[tFCX
 */
#if !defined(AFX_LINE4POINT_H__0ECCF811_2904_4F6B_BF82_6B4C5FA99C27__INCLUDED_)
#define AFX_LINE4POINT_H__0ECCF811_2904_4F6B_BF82_6B4C5FA99C27__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGLine4PointTool Line4Point.h "CurveCmd/Line4Point.h"
///
/// Creates a line from four points. The first two points designates the 
/// endpoints of the base line, and the remainder are endpoints of the new line.
class MGLine4PointTool : public MGLocateState{
public:
	explicit MGLine4PointTool(fugenDoc* pDoc);
	explicit MGLine4PointTool(MGCommandStateOwner* owner);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	
private:
	
	//Make a line and add to the document
	bool make_object();
	void prompt_message() const;
	bool m_bBoth; // IvV
};

#endif // !defined(AFX_LINE4POINT_H__0ECCF811_2904_4F6B_BF82_6B4C5FA99C27__INCLUDED_)
