/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file ExtendLengthTool.h:
 * @brief MGExtendLengthTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEEXTLENTOOL_H__2CCE6606_33C0_4220_9E8F_C7ABD117A366__INCLUDED_)
#define AFX_CURVEEXTLENTOOL_H__2CCE6606_33C0_4220_9E8F_C7ABD117A366__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "GLExtendDlgBase.h"

class CGLCurveExtendDlg;

/** @class MGExtendLengthTool ExtendLengthTool.h "CurveCmd/ExtendLengthTool.h"
 *  Extends a curve with given length.
 */
class MGExtendLengthTool : public MGLocateState{
	std::unique_ptr<MGCurve> m_spPreview; ///< vr[IuWFNg

public:
	explicit MGExtendLengthTool(fugenDoc* pDoc);
	~MGExtendLengthTool()=default;

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnLocated(const MGLocateInfo& info);

	virtual void UpdateView();
	CGLCurveExtendDlg* getCurveExtendDialog();
	const CGLCurveExtendDlg* getCurveExtendDialog()const;

private:
	MGCurve* GetTargetCurve() const;
	MGCurve* ExtendCurve() const;
	void prompt_message() const;
};

#endif // !defined(AFX_CURVEEXTLENTOOL_H__2CCE6606_33C0_4220_9E8F_C7ABD117A366__INCLUDED_)
