/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ElpsDiamAxesTool.h
 * @brief MGElpsDiamAxesTool NX̃C^[tFCX
 */
#if !defined(AFX_ELPSDIAMAXESTOOL_H__50FD1787_7634_448C_95D8_7681BA9B2887__INCLUDED_)
#define AFX_ELPSDIAMAXESTOOL_H__50FD1787_7634_448C_95D8_7681BA9B2887__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Ellipse.h"

class MGCommandStateOwner;

/// @class MGElpsDiamAxesTool ElpsDiamAxesTool.h "CurveCmd/ElpsDiamAxesTool.h"
///
/// Creates an ellipse through its axes.
class MGElpsDiamAxesTool : public MGLocateState{
public:
	explicit MGElpsDiamAxesTool(fugenDoc* pDoc);
	explicit MGElpsDiamAxesTool(MGCommandStateOwner* owner);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;

	bool m_bVert; ///< ȉ~ƕʂɑ΂Đɂ邩ǂ
};
#endif // !defined(AFX_ELPSDIAMAXESTOOL_H__50FD1787_7634_448C_95D8_7681BA9B2887__INCLUDED_)
