/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ElpsCorner.h
 * @brief MGElpsCornerTool NX̃C^[tFCX
 */
#if !defined(AFX_ELPSCORNER_H__B145B2AD_E1CC_4802_99A3_A2C155B423A3__INCLUDED_)
#define AFX_ELPSCORNER_H__B145B2AD_E1CC_4802_99A3_A2C155B423A3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Ellipse.h"

/// @class MGElpsCornerTool ElpsCorner.h "CurveCmd/ElpsCorner.h"
///
/// Creates an ellipse from the corners of an enclosing rectangle.
class MGElpsCornerTool : public MGLocateState{
public:
	explicit MGElpsCornerTool(fugenDoc* pDoc);
	explicit MGElpsCornerTool(MGCommandStateOwner* owner);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	const MGPlane* m_plane; ///< Jgr[ CPlane
};

#endif // !defined(AFX_ELPSCORNER_H__B145B2AD_E1CC_4802_99A3_A2C155B423A3__INCLUDED_)
