/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file Ellipse.cpp
 * @brief MGEllipseTool NX̃Cve[V
 */
#include "stdafx.h"
#include "CurveCmd/Ellipse.h"
#include "CurveCmd/ElpsCenAxesTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEllipseTool

MGEllipseTool::MGEllipseTool(fugenDoc* pDoc)
	 :MGCommandStateOwner(
		 pDoc,
		 ID_CURVE_ELLIPSE_CENTER)
{
}

MGCommandBase* MGEllipseTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEllipseTool(pDoc);
}

bool MGEllipseTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();
	set_child_current_command(new MGElpsCenAxesTool(this));
	return false;
}
