/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// CurveRebuildDlg.cpp : Cve[V t@C

#include <cmath>
#include "stdafx.h"
#include "mg/RLBRep.h"
#include "CurveCmd/CurveRebuildDlg.h"
#include "curverebuilddlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCurveRebuildDlg _CAO


CCurveRebuildDlg::CCurveRebuildDlg(MGRebuildTool* pParent)
:CDialog(CCurveRebuildDlg::IDD),m_parentCMD(pParent),
 m_order(4), m_reparameterize(2), m_splineApprox(1)
 , m_SParam(0.), m_EParam(1.)
 , m_nonRational2(FALSE)
 , m_check2(FALSE)
 , m_tolerance2(MGTolerance::line_zero())
 , m_splineApproxCheck(FALSE)
{}

void CCurveRebuildDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCurveRebuildDlg)
	//}}AFX_DATA_MAP
	DDX_Radio(pDX, IDC_RADIO_NON_REPARA, m_reparameterize);
	DDX_Text(pDX, IDC_EDIT_SPARAM, m_SParam);
	DDX_Text(pDX, IDC_EDIT_EPARAM, m_EParam);
	DDV_MinMaxDouble(pDX,m_EParam,m_SParam,10.e+32);
	DDX_Check(pDX, IDC_CURVE_REBUILD_SAPPROX, m_splineApproxCheck);
	DDX_Check(pDX, IDC_CHECK_NON_RATIONAL, m_nonRational2);
	DDX_Text(pDX, IDC_TOLERANCE, m_tolerance2);
	DDV_MinMaxDouble(pDX, m_tolerance2, 0., 1e10);

	DDX_Text(pDX, IDC_CURVE_REBUILD_ORDER, m_order);
	DDV_MinMaxUInt(pDX, (UINT)m_order, 2, 20);
}

BEGIN_MESSAGE_MAP(CCurveRebuildDlg, CDialog)
	//{{AFX_MSG_MAP(CCurveRebuildDlg)
	ON_BN_CLICKED(IDC_RADIO_NON_REPARA, OnBnClickedRadio0)
	ON_BN_CLICKED(IDC_RADIO_01_REPARA, OnBnClickedRadio1)
	ON_BN_CLICKED(IDC_RADIO_CLEN_REPARA, OnBnClickedRadio2)
	ON_BN_CLICKED(IDC_CURVE_REBUILD_SAPPROX, OnBnClickedCurveRebuildSapprox)
	ON_BN_CLICKED(IDC_RADIO_SPECIFY_RNG, OnBnClickedRadio3)
	ON_BN_CLICKED(IDC_CHECK_NON_RATIONAL, OnBnClickedCheck2)
	//}}AFX_MSG_MAP
	ON_NOTIFY(UDN_DELTAPOS, IDC_CURVE_REBUILD_SPIN_ORDER, OnDeltaposCurveRebuildSpinOrder)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCurveRebuildDlg bZ[W nh

BOOL CCurveRebuildDlg::OnInitDialog(){
	CDialog::OnInitDialog();
	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	CSpinButtonCtrl* pSpin = static_cast<CSpinButtonCtrl*>(GetDlgItem(IDC_CURVE_REBUILD_SPIN_ORDER));
	pSpin->SetRange(2, 20);

	CButton* sapproxButton = static_cast<CButton*>(GetDlgItem(IDC_CURVE_REBUILD_SAPPROX));
	CButton* nonRationalButton = static_cast<CButton*>(GetDlgItem(IDC_CHECK_NON_RATIONAL));
	MGCurve* crv=m_parentCMD->curve();
	CString crvtype=CA2T(crv->whoami().c_str());
	CWnd* wintype = static_cast<CWnd*>(GetDlgItem(IDC_STATIC3));
	//wintype->SetWindowText(_T(crvtype.data()));
	wintype->SetWindowText(crvtype);
	m_tolerance2=double(int(m_tolerance2*10000000.))/10000000.;
	m_SParam=double(int(crv->param_s()*DECIMAL_PLACE_NUMBER))/DECIMAL_PLACE_NUMBER;
	m_EParam=double(int(crv->param_e()*DECIMAL_PLACE_NUMBER))/DECIMAL_PLACE_NUMBER;
	if(m_parentCMD->lbrep()){
		sapproxButton->SetWindowText(_T("Change Order"));
		nonRationalButton->EnableWindow(FALSE);
	}else if(m_parentCMD->rlbrep()){
		sapproxButton->EnableWindow(FALSE);
	}else{
		nonRationalButton->EnableWindow(FALSE);
		m_splineApprox=0;
	}
	enable_orderEdit(m_splineApproxCheck);
	enable_SEParamRange(FALSE);
	m_order=crv->order();
	UpdateData(FALSE);

	CPoint point;
	::GetCursorPos(&point);
	SetWindowPos(&wndTop, point.x, point.y, 0, 0, SWP_NOSIZE);

	return TRUE;
}

void CCurveRebuildDlg::OnDeltaposCurveRebuildSpinOrder(NMHDR *pNMHDR, LRESULT *pResult){
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	*pResult = 0;
}

void CCurveRebuildDlg::OnBnClickedRadio0(){
	m_reparameterize=0;
	enable_SEParamRange(FALSE);
}

void CCurveRebuildDlg::OnBnClickedRadio1(){
	m_reparameterize=1;
	enable_SEParamRange(FALSE);
}

void CCurveRebuildDlg::OnBnClickedRadio2(){
	m_reparameterize=2;
	enable_SEParamRange(FALSE);
}

void CCurveRebuildDlg::OnBnClickedRadio3(){
	m_reparameterize=3;
	enable_SEParamRange(TRUE);
	UpdateData(TRUE);
}

void CCurveRebuildDlg::enable_orderEdit(BOOL active){
	CWnd* win1 = static_cast<CWnd*>(GetDlgItem(IDC_STATIC11));
	win1->EnableWindow(active);
	CWnd* orderEditWnd = static_cast<CWnd*>(GetDlgItem(IDC_CURVE_REBUILD_ORDER));
	orderEditWnd->EnableWindow(active);
	CWnd* orderSpinWnd = static_cast<CWnd*>(GetDlgItem(IDC_CURVE_REBUILD_SPIN_ORDER));
	orderSpinWnd->EnableWindow(active);
}

void CCurveRebuildDlg::enable_SEParamRange(BOOL active){
	CWnd* win2 = static_cast<CWnd*>(GetDlgItem(IDC_STATIC4));
	win2->EnableWindow(active);
	CWnd* win3 = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_SPARAM));
	win3->EnableWindow(active);
	CWnd* win4 = static_cast<CWnd*>(GetDlgItem(IDC_STATIC5));
	win4->EnableWindow(active);
	CWnd* win5 = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_EPARAM));
	win5->EnableWindow(active);
}

void CCurveRebuildDlg::OnBnClickedCurveRebuildSapprox(){
	UpdateData(TRUE);
	if(m_splineApproxCheck)
		m_splineApprox=2;
	else
		m_splineApprox=1;
	enable_orderEdit(TRUE);
}

void CCurveRebuildDlg::get_param(
	int& splineApprox,
	int& reparameterize,
	double& tolerance,
	size_t& ordr,
	double range[2]
)const{
	splineApprox=m_splineApprox;
	reparameterize=m_reparameterize;
	tolerance=m_tolerance2;
	ordr=m_order;
	range[0]=m_SParam;
	range[1]=m_EParam;
}

void CCurveRebuildDlg::OnBnClickedCheck2(){
	MGRLBRep* obj=m_parentCMD->rlbrep();
	if(obj){
		m_splineApproxCheck=FALSE;
		UpdateData(TRUE);
		enable_orderEdit(m_nonRational2);
	}
}
