/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveParamLineTool.h
 * @brief MGCurveParamLineTool NX̃C^[tFCX
 */
#if !defined(AFX_PARAMLINETOOL_H__0E026BCA_8BE1_41EE_827C_DAB62AE14978__INCLUDED_)
#define AFX_PARAMLINETOOL_H__0E026BCA_8BE1_41EE_827C_DAB62AE14978__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

/// @class MGCurveParamLineTool CurveParamLineTool.h CurveCmd/CurveParamLineTool.h
///
/// w肳ꂽȖʂ̎wp[^ɂ
/// AC\J[u (p[^J[uƌĂ) 𒊏oR}h
class MGCurveParamLineTool : public MGCommandStateOwner{
public:
	explicit MGCurveParamLineTool(fugenDoc* pDoc);
	virtual bool OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display=true
	);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	const MGFSurface* m_surf; ///< ΏۂƂȂȖ
	std::vector< std::vector<UniqueCurve> > m_result; ///< vZrp
	std::vector<UniqueCurve> m_tmp; ///< ꎞ`p

	friend class MGParamLineSSurf;
	friend class MGParamLineIPoint;
};

/// @class MGParamLineSSurf
///
/// ΏۂƂȂȖʂw肳
class MGParamLineSSurf : public MGSelectState{
public:
	explicit MGParamLineSSurf(MGCurveParamLineTool* owner);

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
			//unselected_objects.size()>=1 only when the already selected objects are selected
			//when add mode is set(or when operation is done with a crtl key pressed).
		);
private:
	void prompt_message() const;

	MGCurveParamLineTool* state_owner(){
		return static_cast<MGCurveParamLineTool*>(get_owner_command());
	}
};

/// @class MGParamLineIPoint
///
/// p[^m邽߂̏
class MGParamLineIPoint : public MGLocateOnObjects{
public:
	explicit MGParamLineIPoint(MGCurveParamLineTool* owner);
	virtual ~MGParamLineIPoint();

	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:
	void prompt_message() const;

	MGCurveParamLineTool* state_owner(){
		return static_cast<MGCurveParamLineTool*>(get_owner_command());
	}

	bool m_bU; ///< UJ[uVJ[uB͂̃R}hł͂łȂB
	//true if v=const, false if u=const param line be generated.
};

#endif // !defined(AFX_PARAMLINETOOL_H__0E026BCA_8BE1_41EE_827C_DAB62AE14978__INCLUDED_)
