/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CurveKnotRemove.h
 * @brief MGCurveKnotRemoveTool NX̃C^[tFCX
 */
#if !defined( __CURVEREMOVEKNOT_H__)
#define __CURVEREMOVEKNOT_H__

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateOnObjects.h"

/// @class MGCurveKnotRemoveTool CurveKnotRemove.h CurveCmd/CurveKnotRemove.h
///
/// Removes knots from a curve.
class MGCurveKnotRemoveTool : public MGCommandStateOwner{
	friend class MGCurveKnotRemoveSCurve;
	friend class MGCurveKnotRemoveSKnot;
public:
	explicit MGCurveKnotRemoveTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

	const MGPickObject& curve() const;
	void set_curve(const MGPickObject& curve);

	void insert_knot(int nId);
	void cancel_last_insertion();

private:
	MGLBRep* remove_knot();

	MGPickObject m_curve; ///< ΏۂƂȂȐ
	std::vector<int> m_knotIDs;
};

/// @class MGCurveKnotRemoveSCurve
/// 
/// mbg邽߂̋ȐIB
/// MGLBRep̂ݗLłB
class MGCurveKnotRemoveSCurve : public MGSelectState{
public:
	MGCurveKnotRemoveSCurve(MGCurveKnotRemoveTool* owner);

	MGCurveKnotRemoveTool* state_owner(){
		return static_cast<MGCurveKnotRemoveTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

/// @class MGCurveKnotRemoveSKnot
///
/// mbgʒuɕ\Ă_usbNvB
class MGCurveKnotRemoveSKnot : public MGLocateOnObjects{
public:
	MGCurveKnotRemoveSKnot(MGCurveKnotRemoveTool* owner);

	MGCurveKnotRemoveTool* state_owner(){
		return static_cast<MGCurveKnotRemoveTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	virtual bool OnLocated(const MGLocateInfo& linfo);
};

#endif //__CURVEREMOVEKNOT_H__
