/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CurveKnotInsertTool.h
 * @brief NX MGCurveKnotInsertTool ̐錾
 */
#if !defined(AFX_CURVEKNOTTOOL_H__BD38E701_C3FE_4CA4_8621_9FCE7C830451__INCLUDED_)
#define AFX_CURVEKNOTTOOL_H__BD38E701_C3FE_4CA4_8621_9FCE7C830451__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/LBRep.h"
#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

/// @class MGCurveKnotInsertTool CurveKnotInsertTool.h CurveCmd/CurveKnotInsertTool.h
///
/// Adds knots to a curve.
class MGCurveKnotInsertTool : public MGCommandStateOwner{
public:
	explicit MGCurveKnotInsertTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

// EVENT
protected:

	//Invoked when command is to terminate as a nomal end.
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

private:
	MGLBRep* m_curve;
	MGLBRep  m_tmp;

	//set the curve data into this member variables.
	void set_the_member_data(MGPickObjects& curves);

	friend class MGCurveKnotInsertToolSCurve;
	friend class MGCurveKnotInsertToolIPoint;
};

//curve selection class.
class MGCurveKnotInsertToolSCurve : public MGSelectState{
public:
	MGCurveKnotInsertTool* state_owner(){
		return static_cast<MGCurveKnotInsertTool*>(get_owner_command());
	}
	MGCurveKnotInsertToolSCurve(MGCommandStateOwner* owner);
	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

//Weight data for the smoothing input class.
class MGCurveKnotInsertToolIPoint : public MGLocateState{
public:
	MGCurveKnotInsertTool* state_owner(){
		return static_cast<MGCurveKnotInsertTool*>(get_owner_command());
	}
	MGCurveKnotInsertToolIPoint(MGCommandStateOwner* owner);
	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& linfo);
	
/// Compiles OpenGL's display list of temporary objects for each
///standard views.
void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

//Invoked when command is to terminate as a nomal end.
bool OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
			//=1: display "xxxx" normally end.
			//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display=true
)override{
	return state_owner()->OnCommandEnd(1);
}

};

#endif // !defined(AFX_CURVEKNOTTOOL_H__BD38E701_C3FE_4CA4_8621_9FCE7C830451__INCLUDED_)
