/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveExtractWire.cpp
 * @brief MGCurveExtractWireTool NX̃Cve[V
 */
#include "stdafx.h"
#include "CurveCmd/CurveExtractWire.h"
#include "Calc/mgcalc.h"
#include "Calc/mgfunctor.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCurveExtractWireTool

MGCurveExtractWireTool::MGCurveExtractWireTool(fugenDoc* pDoc)
	 : MGSelectState(
		 pDoc,
		 ID_CURVE_EXTRACT_WIRE,
		 MGSelectState::MULTIPLE_SELECT,
		 mgAll_FSurface),
	   m_nIDS(1)
{
}

MGCommandBase* MGCurveExtractWireTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGCurveExtractWireTool(pDoc);
}

bool MGCurveExtractWireTool::initiate_tool(){
	MGSelectState::initiate_tool();

	// IfI
	if(current_object_is_valid(mgAll_FSurface,m_surf)){
		set_current_object(m_surf);
		// vZJn
		if(!calculate()){
			return OnCommandEnd(m_nIDS);
		}
		return OnCommandEnd(1);
	}

	set_add_mode();
	prompt_message();
	return false;
}

bool MGCurveExtractWireTool::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	switch(nChar){
	case VK_RETURN:
		m_surf = current_objects();
		if(m_surf.empty()){
			// LZ
			return OnCommandEnd(m_nIDS);
		}

		// vZJn
		if(!calculate()){
			return OnCommandEnd(m_nIDS);
		}
		return OnCommandEnd(1);
	default:
		return MGSelectState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
	}
}

bool MGCurveExtractWireTool::calculate(){
	SetStatusMessage(IDS_PROMPT_COMPUTE);	// bZ[W

	// XPgxAReLXg擾Ă悢ȂB
	const int nDensity = UserPreference::getInstance().GetIntValue(upv_IsoCurve_Density);
	MGGelPositions gelps;
	for(auto& srfi:m_surf){
		const MGFSurface* srf = dynamic_cast<const MGFSurface*>(srfi->top_object());
		ASSERT(srf);
		MGGroup* grp=srfi->bottom_group();
		std::vector<UniqueCurve> born = srf->skeleton(nDensity);
		for(auto& borni:born)
			gelps.append(MGGelPosition(grp, borni.release()));
	}
	if(gelps.empty()){
		m_nIDS = IDS_FAIL_GENERATE_CURVE;
		return false;
	}

	// hLgύX
	add_object_to_document(gelps);
	return true;
}

void MGCurveExtractWireTool::prompt_message() const{
	SetStatusMessage(IDS_PROMPT_SURFACE);
}
