/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveExtractCPoint.h
 * @brief MGCurveExtractCPointTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEEXTRACTCPOINT_H__1A81BC4A_DC30_475D_8E47_55F127959071__INCLUDED_)
#define AFX_CURVEEXTRACTCPOINT_H__1A81BC4A_DC30_475D_8E47_55F127959071__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveExtractCPointTool CurveExtractCPoint.h CurveCmd/CurveExtractCPoint.h
///
/// PɂׂĂ̐_WIgƂĒo邾B
class MGCurveExtractCPointTool : public MGSelectState{
public:
	explicit MGCurveExtractCPointTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& added,
		MGPickObjects& removed);

private:
	bool calculate();
	void prompt_message() const;
	void UpdatePreview();
	
	MGPickObjects m_curve; ///< sbNꂽׂĂ̋Ȑ
	std::vector<MGPosition> m_preview_points;
	UINT m_nIDS;  ///< error message
};

#endif // !defined(AFX_CURVEEXTRACTCPOINT_H__1A81BC4A_DC30_475D_8E47_55F127959071__INCLUDED_)
