/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveConvert.h
 * @brief MGCurveConvertTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVECONVERT_H__B92663BD_C32A_4CA8_8001_0762B5EA9303__INCLUDED_)
#define AFX_CURVECONVERT_H__B92663BD_C32A_4CA8_8001_0762B5EA9303__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveConvertTool CurveConvert.h CurveCmd/CurveConvert.h
///
/// Ȑ|C܂͉~ʂڑ悤ȋȐɕϊR}h
class MGCurveConvertTool : public MGSelectState{
public:
	explicit MGCurveConvertTool(fugenDoc* pDoc, UINT nCmdID);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();
	void prompt_message() const;

	MGPickObjects  m_curve;   // ϊΏۂƂȂȐIuWFNg

	double m_azero; ///< ϊvẐƂɗp angle_zero ̒l
	double m_lzero; ///< ϊvẐƂɗp line_zero ̒l
	UINT m_nIDS; ///< spbZ[W
	bool m_bPolyline; ///< true : |Cɕϊ false : ~ʂɕϊ
	bool m_bRemove; ///< IWi̋Ȑ폜邩ǂ
};

MGCommandBase* CreateCurveConvertTool(fugenDoc* pDoc, UINT nCmdID);

#endif // !defined(AFX_CURVECONVERT_H__B92663BD_C32A_4CA8_8001_0762B5EA9303__INCLUDED_)
