/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CurveChamfer.h
 * @brief MGCurveChamferTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVECHAMFER_H__B319CD05_9CF9_4AEE_AD98_E5A69CE76963__INCLUDED_)
#define AFX_CURVECHAMFER_H__B319CD05_9CF9_4AEE_AD98_E5A69CE76963__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveChamferTool CurveChamfer.h CurveCmd/CurveChamfer.h
/// 
/// Chamfers two curves.
class MGCurveChamferTool : public MGSelectState{
public:
	explicit MGCurveChamferTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnSelected(fugenView* pView, MGPickObjects&, MGPickObjects&);

private:
	bool calculate();
	bool input_param();
	void prompt_message() const;

	MGPickObject m_curve1; ///< ΏۋȐ1
	MGPickObject m_curve2; ///< ΏۋȐ2
	double m_dDistance1; ///< ʎ苗{>=0}
	double m_dDistance2; ///< ʎ苗{>=0}
	UINT m_nIDS; ///< G[bZ[W
	bool m_bJoin; ///< Ȑڍ邩ǂ
	bool m_bTrim; ///< ̋Ȑg(orvZ̈ꎞg)ǂ
};

#endif // !defined(AFX_CURVECHAMFER_H__B319CD05_9CF9_4AEE_AD98_E5A69CE76963__INCLUDED_)
