/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveBoundaryTool.h
 * @brief MGCurveBoundaryTool NX̃C^[tFCX
 */
#if !defined(AFX_BOUNDARYCURVETOOL_H__B92734D6_ADF1_490E_B262_2770B9198638__INCLUDED_)
#define AFX_BOUNDARYCURVETOOL_H__B92734D6_ADF1_490E_B262_2770B9198638__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveBoundaryTool CurveBoundaryTool.h CurveCmd/CurveBoundaryTool.h
///
/// Extracts all of the boundary curves from a face.
class MGCurveBoundaryTool : public MGSelectState{
public:
	explicit MGCurveBoundaryTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	
private:
	bool calculate();
	MGPickObjects m_surf;
};

#endif // !defined(AFX_BOUNDARYCURVETOOL_H__B92734D6_ADF1_490E_B262_2770B9198638__INCLUDED_)
