/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CurveBoundaryTool.cpp
 * @brief MGCurveBoundaryTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "CurveCmd/CurveBoundaryTool.h"
#include "Calc/mgcalc.h"
#include "Calc/mgfunctor.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCurveBoundaryTool

MGCurveBoundaryTool::MGCurveBoundaryTool(fugenDoc* pDoc)
: MGSelectState(pDoc,ID_CURVE_BOUNDARY,MULTIPLE_SELECT,mgAll_FSurface){
}

MGCommandBase* MGCurveBoundaryTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCurveBoundaryTool(pDoc);
}

bool MGCurveBoundaryTool::initiate_tool(){
	MGSelectState::initiate_tool();

	if(current_object_is_valid(mgAll_FSurface,m_surf)){
		set_current_object(m_surf);
		UINT nIDS=1;//success.
		if(!calculate()){
			nIDS=2;//failed
		}
		return OnCommandEnd(nIDS);
	}else{
		set_add_mode();
		SetStatusMessage(IDS_PROMPT_SURFACE);
	}
	return false;
}

bool MGCurveBoundaryTool::calculate(){
	SetStatusMessage(IDS_PROMPT_COMPUTE);
	m_surf.remove(mgAll_Plane);
	MGGelPositions gelps;
	for (auto& gelp : m_surf) {
		const MGFSurface* surf = gelp->top_object()->fsurface();
		std::vector<UniqueCurve> crvs = surf->get_all_boundaries();
		for (auto& crv : crvs)
			gelps.append(MGGelPosition(gelp->bottom_group(), crv.release()));

	}
	if(gelps.empty())
		return false;

	// hLgύX
	add_object_to_document(gelps);
	return true;
}

bool MGCurveBoundaryTool::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	UINT nIDS=1;
	switch(nChar){
	case VK_RETURN:
		current_object_is_valid(mgAll_FSurface, m_surf);
		set_current_object(m_surf);

		if(current_objects().empty()){
			// LZ
			nIDS=3;
		}else if(!calculate()){
			nIDS=2;
		}
		// I
		return OnCommandEnd(nIDS);
	default:
		return MGSelectState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
	}
}
