/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file CurveBlendTool.h
 * @brief MGCurveBlendTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEBLENDTOOL_H__BA0D3F96_306C_4DD2_9514_57EE6FAC8E14__INCLUDED_)
#define AFX_CURVEBLENDTOOL_H__BA0D3F96_306C_4DD2_9514_57EE6FAC8E14__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

class CSliderDlg;

/// @class MGCurveBlendTool CurveBlendTool.h CurveCmd/CurveBlendTool.h
///
/// Creates a curve by blending between two curves.
class MGCurveBlendTool : public MGSelectState{
public:
	explicit MGCurveBlendTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	//virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnSelected(fugenView* pView, MGPickObjects&, MGPickObjects&);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	bool calculate();
	const MGCurve* c = dynamic_cast<MGCurve*>(m_curve1.top_object());
	MGCurve* curve1(){ return dynamic_cast<MGCurve*>(m_curve1.top_object());}
	MGCurve* curve2(){ return dynamic_cast<MGCurve*>(m_curve2.top_object()); }
		void prompt_message() const;

	// sbNꂽȐ̏
	MGPickObject m_curve1;
	MGPickObject m_curve2;

	std::unique_ptr<MGCurve> m_tmp; ///< ꎞ`pIuWFNg

	UINT m_nIDS; ///< error message
	bool m_first; ///< _CAO{bNX(x)ƂɎgptO
};

#endif // !defined(AFX_CURVEBLENDTOOL_H__BA0D3F96_306C_4DD2_9514_57EE6FAC8E14__INCLUDED_)
