/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file Curve3DComposite.h
 * @brief MGCurve3DCompositeTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVE3DCOMPOSE_H__3B126889_5898_4CE3_B2C7_CB0F06C4C0E0__INCLUDED_)
#define AFX_CURVE3DCOMPOSE_H__3B126889_5898_4CE3_B2C7_CB0F06C4C0E0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurve3DCompositeTool Curve3DComposite.h CurveCmd/Curve3DComposite.h
///
/// Creates a curve from two curves that are planar to different planes. 
/// The new curve looks the same as each of the original curves when viewed in each plane. 
class MGCurve3DCompositeTool : public MGSelectState{
public:
	explicit MGCurve3DCompositeTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);

private:
	bool calculate();
	void prompt_message() const;

	std::pair<const MGCurve*, const MGCurve*> m_curves; ///< ʋȐł邱
};

#endif // !defined(AFX_CURVE3DCOMPOSE_H__3B126889_5898_4CE3_B2C7_CB0F06C4C0E0__INCLUDED_)
