/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CornerR_CPRTool.h
 * @brief MGCornerR_CPRTool NX̃C^[tFCX
 */
#if !defined(AFX_CORNERR_CPRTOOL_H__B4BFFA93_EE06_4D30_85C1_759D96431A0A__INCLUDED_)
#define AFX_CORNERR_CPRTOOL_H__B4BFFA93_EE06_4D30_85C1_759D96431A0A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCornerR_CPRTool CornerR_CPRTool.h "CurveCmd/CornerR_CPRTool.h"
///
/// Creates an arc from a curve, the arc's end point, and the radius.
class MGCornerR_CPRTool : public MGLocateState
{
	double m_dRadius;

public:
	explicit MGCornerR_CPRTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	bool input_param();
	void prompt_message() const;
};

#endif // !defined(AFX_CORNERR_CPRTOOL_H__B4BFFA93_EE06_4D30_85C1_759D96431A0A__INCLUDED_)
