/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CornerR_CPPTool.h
 * @brief MGCornerR_CPPTool NX̃C^[tFCX
 */
#if !defined(AFX_CORNERR_CPPTOOL_H__26933D83_7FB6_4E9B_AAB8_C093C1AA0F91__INCLUDED_)
#define AFX_CORNERR_CPPTOOL_H__26933D83_7FB6_4E9B_AAB8_C093C1AA0F91__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCurve;
class MGCommandStateOwner;

/// @class MGCornerR_CPPTool CornerR_CPPTool.h "CurveCmd/CornerR_CPPTool.h"
///
/// Creates an arc from a tangent point on a curve and a point.
class MGCornerR_CPPTool : public MGLocateState{

public:
	explicit MGCornerR_CPPTool(fugenDoc* pDoc);
	explicit MGCornerR_CPPTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;
	MGCurve* Compute(const MGPosition& pos) const;

	typedef std::pair<const MGCurve*, double> pair;
	pair m_pair; ///< // ڐƂ邽߂̋ȐƁAʒuɂp[^
};

#endif // !defined(AFX_CORNERR_CPPTOOL_H__26933D83_7FB6_4E9B_AAB8_C093C1AA0F91__INCLUDED_)
