/*****************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                          */
/* ************************************************************* */

/**
 * @file CircleDiamTool.cpp
 * @brief MGCircleDiamTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "Common/CommandStateOwner.h"
#include "CurveCmd/CircleDiamTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCircleDiamTool

MGCircleDiamTool::MGCircleDiamTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_CIRCLE_DIAMETER,NO_RUBBER,POINT_IPDRAW){
}

MGCircleDiamTool::MGCircleDiamTool(MGCommandStateOwner* owner)
: MGLocateState(owner, UNLOCK_SNAP_ATTRIB, NO_RUBBER, POINT_IPDRAW){
}

MGCommandBase* MGCircleDiamTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCircleDiamTool(pDoc);
}

void MGCircleDiamTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pSView){
	const LInfoVec& linfos=locates();
	if(linfos.empty())
		return;

	std::unique_ptr<MGCurve> circle=makeModel(cursor());
	if(circle.get()){
		MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
		circle->drawWire(sgl);
	}
}

bool MGCircleDiamTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t n=linfos.size();
	if(n<=1){
		const MGLocateInfo& linfo=*linfos[0];
		const MGVector& normal=linfo.window()->cplane().plane().normal();
		setPlanarRestrictionPointToProhibitUpdate(normal,linfo.point_world());
		return false;
	}

	// hLgύX
	const MGPosition& P1=linfos[1]->point_world();
	std::unique_ptr<MGCurve> circle=makeModel(P1);
	add_object_to_current_group(circle.release());
	return OnCommandEnd(1); // R}hI
}

void MGCircleDiamTool::prompt_message() const{
	const LInfoVec& linfos=locates();
	switch(linfos.size()){
	case 0:
		SetStatusMessage(IDS_PROMPT_CIRCLE_DIAM_START);
		break;
	case 1:
		SetStatusMessage(IDS_PROMPT_CIRCLE_DIAM_END);
		break;
	}
}

std::unique_ptr<MGCurve> MGCircleDiamTool::makeModel(const MGPosition& P1){
	const auto& linfos=locates();

	// vZJn
	const MGPosition& P0=linfos[0]->point_world();
	MGPosition center((P0+P1)*.5);
	double r=center.distance(P1);

	// hLgύX
	const MGVector& normal=linfos[0]->window()->cplane().plane().normal();
	return std::unique_ptr<MGCurve>(new MGEllipse(center,r,normal));
}
