/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CircleAroundCurve.h
 * @brief MGCircleAroundCurveTool NX̃C^[tFCX
 */
#pragma once

#include "Common/LocateState.h"

class MGEllipse;

/// @class MGCircleAroundCurveTool CircleAroundCurve.h "CurveCmd/CircleAroundCurve.h"
///
/// ȉ~R}h̋Ȑ[hB
class MGCircleAroundCurveTool : public MGLocateState
{
	const MGCurve* m_curve;//The objective curve.
	double m_t;//The parameter value of the m_curve.
	MGVector m_normal;
	bool m_bNear; ///< NEAR Xibv̌X̏

public:
	explicit MGCircleAroundCurveTool(MGCommandStateOwner* owner);

	//virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void prompt_message() const;
	MGEllipse* create_circle(const MGPosition& epos) const;
};
