/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file Circle3P.cpp
 * @brief MGCircle3P NX̃Cve[V
 */
#include "stdafx.h"
#include "Calc/mgcalc.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "Common/CommandStateOwner.h"
#include "CurveCmd/Circle3P.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCircle3PTool

MGCircle3PTool::MGCircle3PTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_CIRCLE_3POINTS,NO_RUBBER,POINT_IPDRAW){
}

MGCircle3PTool::MGCircle3PTool(MGCommandStateOwner* owner)
: MGLocateState(owner, UNLOCK_SNAP_ATTRIB, NO_RUBBER, POINT_IPDRAW){
}

MGCommandBase* MGCircle3PTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCircle3PTool(pDoc);
}

void MGCircle3PTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pSView){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	if(np<2)
		return;

	const MGPosition& P0=linfos[0]->point_world();
	const MGPosition& P1=linfos[1]->point_world();
	MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
	MGEllipse circle(P0,cursor(),P1,true);
	circle.drawWire(sgl);
}

bool MGCircle3PTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	// bZ[WXV
	if(np<3){
		return false;
	}

	// vZJn,hLgύX
	const MGPosition& P0=linfos[0]->point_world();
	const MGPosition& P1=linfos[1]->point_world();
	const MGPosition& P2=linfos[2]->point_world();
	add_object_to_current_group(new MGEllipse(P0,P2,P1,true));
	return OnCommandEnd(1); // R}hI
}

void MGCircle3PTool::prompt_message() const{
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	SetStatusMessage(IDS_PROMPT_CIRCLE, np+1);
}
