/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file Circle.cpp
 * @brief MGCircleTool NX̃Cve[V
 */
#include "stdafx.h"
#include "CurveCmd/Circle.h"
#include "CurveCmd/CircleCRTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCircleTool

MGCircleTool::MGCircleTool(fugenDoc* pDoc)
	 :MGCommandStateOwner(
		 pDoc,
		 ID_CURVE_CIRCLE_CENTER_RADIUS)
{
}

MGCommandBase* MGCircleTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGCircleTool(pDoc);
}

bool MGCircleTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();

	set_child_current_command(new MGCircleCRTool(this));
	return false;
}
