/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file ArcSET.cpp
 * @brief MGArcSETTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "Common/CommandStateOwner.h"
#include "GLInputRealDlg.h"
#include "CurveCmd/ArcSET.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGArcSETTool

MGArcSETTool::MGArcSETTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_ARC_SET,LINE_RUBBER,POINT_IPDRAW){
}

MGArcSETTool::MGArcSETTool(MGCommandStateOwner* owner)
: MGLocateState(owner, UNLOCK_SNAP_ATTRIB, LINE_RUBBER, POINT_IPDRAW){
}

MGCommandBase* MGArcSETTool::initial_clone(fugenDoc* pDoc)const{
	return new MGArcSETTool(pDoc);
}

void MGArcSETTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	if(np>=2){
		const MGPosition& P0=linfos[0]->point_world();
		const MGPosition& P1=linfos[1]->point_world();
		MGEllipse tmp(P0,cursor(),P1);//start, through, end points.
		MGPosition center=tmp.center();
		sgl.drawPoint(center);

		MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
		tmp.drawWire(sgl);
	}
}

bool MGArcSETTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	if(np<3){
		if(np==2)
			setDrawerRubber(NO_RUBBER);
		else
			setDrawerRubber(LINE_RUBBER);
		return false;
	}
	
	// vZăhLgύX
	const MGPosition& P0=linfos[0]->point_world();
	const MGPosition& P1=linfos[1]->point_world();
	const MGPosition& P2=linfos[2]->point_world();
	add_object_to_current_group(new MGEllipse(P0,P2,P1));
	return OnCommandEnd(1);
}

void MGArcSETTool::prompt_message() const{
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	UINT nIDS;
	if(np==0)
		nIDS=IDS_PROMPT_ARC_SED_START;
	else if(np==1)
		nIDS=IDS_PROMPT_ARC_SED_END;
	else
		nIDS=IDS_PROMPT_ARC_SED_THROUGH;
	SetStatusMessage(nIDS);
}
