/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file ArcSER.h
 * @brief MGArcSERTool NX̃C^[tFCX
 */
#if !defined(AFX_ARCSER_H__5B5A072F_8392_40BD_8AEA_40169FD6BED2__INCLUDED_)
#define AFX_ARCSER_H__5B5A072F_8392_40BD_8AEA_40169FD6BED2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Ellipse.h"

class MGCommandStateOwner;

/// @class MGArcSERTool ArcSER.h "CurveCmd/ArcSER.h"
///
/// [~ - n_AI_Aaw]ɑΉR}hNX
class MGArcSERTool : public MGLocateState
{
	enum LocateMode	{
		RADIUS, ///< aw胂[hiʏj
		DIRECTION, ///< ڐƏI_
		THROUGH ///< ʉߓ_ƏI_
	};

	LocateMode m_mode;
	double m_radius; ///< a̒l
	double m_minimumRadius;///Minimum radius which is the half of the distance of 
					//start and end.

public:
	explicit MGArcSERTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
private:
	MGEllipse* create_arc(const MGPosition& epos) const;
	void prompt_message() const;
};

#endif // !defined(AFX_ARCSER_H__5B5A072F_8392_40BD_8AEA_40169FD6BED2__INCLUDED_)
