/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file ArcSED.cpp
 * @brief MGArcSEDTool NX̃Cve[V
 */
#include "stdafx.h"
#include "Calc/mgcalc.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "CurveCmd/ArcSED.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGArcSEDTool

MGArcSEDTool::MGArcSEDTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_ARC_SED,LINE_RUBBER,POINT_IPDRAW){
}

MGCommandBase* MGArcSEDTool::initial_clone(fugenDoc* pDoc)const{
	return new MGArcSEDTool(pDoc);
}

void MGArcSEDTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const LInfoVec& linfos=locates();
	if(linfos.size()>=2){
		const MGPosition& P0=linfos[0]->point_world();
		const MGPosition& P1=linfos[1]->point_world();

		// ڐ`悷
		MGColor::get_instance(MGColor::White).exec(sgl);
		sgl.drawStraight(P0, cursor());

		MGEllipse tmp(P0,P1,cursor()-P0);
		// S
		MGPosition center=tmp.center();
		sgl.drawPoint(center);
		
		// ~ʖ{
		MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
		tmp.drawWire(sgl);
	}
}

bool MGArcSEDTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	size_t np=linfos.size();
	if(np < 3){
		if(np==2)
			setDrawerRubber(NO_RUBBER);
		else
			setDrawerRubber(LINE_RUBBER);
		return false;
	}
	
	// vZďI
	const MGPosition& P0=linfos[0]->point_world();
	const MGPosition& P1=linfos[1]->point_world();
	const MGPosition& P2=linfos[2]->point_world();
	add_object_to_current_group(new MGEllipse(P0,P1,P2-P0));
	return OnCommandEnd(1);
}

void MGArcSEDTool::prompt_message() const{
	const LInfoVec& linfos=locates();
	size_t np = linfos.size();
	UINT nIDS = 0;

	if(np==0)
		nIDS = IDS_PROMPT_ARC_SED_START;
	else if(np==1)
		nIDS = IDS_PROMPT_ARC_SED_END;
	else 
		nIDS = IDS_PROMPT_ARC_SED_DIR;
	SetStatusMessage(nIDS);
}

