/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * @file ArcCenStAng.h
 * @brief MGArcCenStAngTool NX̃C^[tFCX
 */
#if !defined(AFX_ARCCENSTANG_H__2EFF00CE_0DA0_4264_9AAB_7E8677D75485__INCLUDED_)
#define AFX_ARCCENSTANG_H__2EFF00CE_0DA0_4264_9AAB_7E8677D75485__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGArcCenStAngTool ArcCenStAng.h "CurveCmd/ArcCenStAng.h"
///
/// Creates an arc from the center, start, and angle.
class MGArcCenStAngTool : public MGLocateState{
	bool m_bOpposite; ///< false:unticlockwise, true:clockwise.

public:
	explicit MGArcCenStAngTool(fugenDoc* doc);
	explicit MGArcCenStAngTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	void prompt_message() const;
	MGCurve* Compute(fugenView* pView, const MGPosition& pos);
};

#endif // !defined(AFX_ARCCENSTANG_H__2EFF00CE_0DA0_4264_9AAB_7E8677D75485__INCLUDED_)
