/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#if !defined(AFX_CONTOURDLG_H__EA2ED707_4427_4691_99AA_7CA7B8E16477__INCLUDED_)
#define AFX_CONTOURDLG_H__EA2ED707_4427_4691_99AA_7CA7B8E16477__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include "mg/Box.h"
#include "mg/Vector.h"

/////////////////////////////////////////////////////////////////////////////
// CContourDlg _CAO

class CContourDlg : public CDialog
{
// RXgNV
public:
	CContourDlg(const MGBox& border = mgNULL_BOX);

// _CAO f[^
	//{{AFX_DATA(CContourDlg)
	enum { IDD = IDD_CONTOUR };
	CStatic	m_staZ;
	CStatic	m_staY;
	CStatic	m_staX;
	double	m_dPitch;
	BOOL	m_bSliceX;
	BOOL	m_bSliceY;
	BOOL	m_bSliceZ;
	double  m_dThroughX;
	double  m_dThroughY;
	double  m_dThroughZ;
	//}}AFX_DATA

	const MGBox& GetBoundingBox() const{ return m_bxBound;}
	double GetContourPitch() const{ return m_dPitch;}

	void SetBorder(const MGBox& border){ m_bxBound = border;}


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CContourDlg)
	public:
	virtual INT_PTR DoModal();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual void LoadParam();
	virtual void SaveParam() const;

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CContourDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnCheckX();
	afx_msg void OnCheckY();
	afx_msg void OnCheckZ();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	MGBox m_bxBound;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CONTOURDLG_H__EA2ED707_4427_4691_99AA_7CA7B8E16477__INCLUDED_)
