/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file IdleCommand.h
 * @brief declaration of class MGIdleCommandTool
 */
#if !defined( __IDLECOMMANDTOOL_H__)
#define __IDLECOMMANDTOOL_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGIdleCommandTool IdleCommand.h "Common/IdleCommand.h"
///
/// class Document's idle command. The mission is:
///  -# record the last executed command to redo the command by hitting the enter key.
///  -# select an object by MGSelectState.
class MGIdleCommandTool: public MGSelectState{
public:
	MGIdleCommandTool();

	virtual void ModifyContextMenu(CMenu& popup);
	virtual bool CanHandle(UINT nID) const;
	virtual bool HandleMessage(UINT nID);
	virtual bool HandleUpdateUI(UINT nID, CCmdUI* pCmdUI);

	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

	///Set the last command executed.
	///lastC must be a newed object and the ownership will be transfered to this.
	void set_last_command(MGCommandBase* lastC){
		m_last_command.reset(lastC);
	}

	///Get the last command
	MGCommandBase* get_last_command(){return m_last_command.get();}

	///release the last command.
	MGCommandBase* release_last_command(){return m_last_command.release();}

private:
	void InvokeLastCommand();

	std::unique_ptr<MGCommandBase> m_last_command;
};

#endif // !defined(__IDLECOMMANDTOOL_H__)
