/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file IdleCommand.cpp
 * @brief IdleCommand.h ̎B
 */
#include "StdAfx.h"

#include "fugenDoc.h"
#include "Common/IdleCommand.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// class Document's idle command. The mission is:
//(1) record the last executed command to redo the command by hitting the enter key.
//(2) select an object by MGSelectState.

MGIdleCommandTool::MGIdleCommandTool()
:MGSelectState(0,IDS_IDLE_COMMAND_NAME,MGSelectState::MULTIPLE_SELECT){;}

void MGIdleCommandTool::ModifyContextMenu(CMenu& popup)
{
	InsertMenu(IDR_MENU_LAST_COMMAND, popup);
}

bool MGIdleCommandTool::CanHandle(UINT nID) const
{
	return nID == ID_COMMAND_LAST;
}

bool MGIdleCommandTool::HandleMessage(UINT nID)
{
	if(nID == ID_COMMAND_LAST){
		InvokeLastCommand();
		return true;
	}
	return false;
}

bool MGIdleCommandTool::HandleUpdateUI(UINT nID, CCmdUI* pCmdUI)
{
	if(nID == ID_COMMAND_LAST){
		pCmdUI->Enable(m_last_command.get() != 0);
		return true;
	}
	return false;
}

bool MGIdleCommandTool::OnKeyDown(
	fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags
){
	if(nChar == VK_RETURN){
		InvokeLastCommand();
	}else if(nChar!= VK_ESCAPE){//We neglect esc key.
		MGSelectState::OnKeyDown(pView,nChar,nRepCnt,nFlags);
	}
	return false;
}

void MGIdleCommandTool::InvokeLastCommand(){
	MGCommandBase* comnd=m_last_command.get();
	if(comnd){
		fugenDoc* pDoc = document();
		MGCommandBase* lastcmd = comnd->initial_clone(pDoc);
		if(lastcmd){
			pDoc->set_current_command_tool(lastcmd);
			//m_last_command.reset();
			return;
		}else{
			CString str;
			const CString& strName=comnd->command_name();
			str.Format(IDS_PROMPT_FAILED_LAST_COMMAND, strName);

			// o̓EBhEɌx\
			putInOutputWindow(str);
		}
	}else{
		SetStatusMessage(IDS_PROMPT_EMPTY_LAST_COMMAND);
	}
}
