/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file GridCursor.h
 * @brief NX MGGridCursor ̐錾
 */
#pragma once

class MGPosition;
class mgGLSLProgram;
class mgTexture;
class MGLocateInfo;

#include "mgGL/VBO.h"

///defines rubberband line kind for the current input position.
enum  RUBBER_KIND{
	NO_RUBBER=0,///<no rubberband line
	LINE_RUBBER	///<straight line rubberband
};

///defines what kind of trace be drawn for the past input positions.
enum IPOINT_DRAWER_KIND{
	NO_IPDRAW=0,	///<no traces.
	POINT_IPDRAW,	///<only points.
	LINE_IPDRAW,	///<only a polyline.
	POINTLINE_IPDRAW///<both points and a polyline.
};

/// @class MGGridCursor GridCursor.h "Common/GridCursor.h"
/// OpenGL ŃJ[\C[W`悷邽߂̃NXB
class MGGridCursor:public mgVBO{
	friend class MGLocateState;

protected:
	const MGPosition* m_cursor;///Mouse cursor position of the interaction.

public:

	/// ftHgRXgN^[
	MGGridCursor(){;};

	virtual ~MGGridCursor(){;};

	///m_gel̕`f[^쐬݂̂ȂB
	///łɍ쐬ς݂łĂIɍč쐬sB
	///m_gel=0̂Ƃ͂ȂɂȂB
	virtual void make_display_list(MGCL::VIEWMODE vmode=MGCL::DONTCARE);
	
	///`֐draw()́Ais_made()ł΁A쐬A\B
	///!is_made()(`f[^쐬ς݁jł΁Ałɍ쐬ꂽmgVBOElement̕`sB
	///MGGridCursor::draw() draws the grid cursor image.
	virtual void draw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);
	
	const MGPosition& cursor()const{return *m_cursor;};
	//const std::vector<MGPosition>* points()const{return m_points;};
	const LInfoVec* lpoints()const{return m_lpoints;};

	virtual void draw_contents();

	///Points drawer service program.
	virtual void draw_points();

	///Polyline drawer service program.
	virtual void draw_lines();

	//Singleton cursor get.
	mgVBO* getGridCursor();

private:
	mgTexture* m_gridCursorTexture;

	RUBBER_KIND m_rubberKind;//Rubberband line kind.
	IPOINT_DRAWER_KIND m_pointDrawKind;//Rubberband line kind.
	//const std::vector<MGPosition>* m_points;///Input positions so far for the command.
	const LInfoVec* m_lpoints;///Input positions so far for the command.

	float m_LWidthPLine;//Linewidth of m_pointDrawKind line.
	float m_LWidthRubber;//Linewidth of m_pointDrawKind line.
	MGColor m_pointColor;//color of the points ipos.
	MGColor m_lineColor;//color of the points ipos.
	MGColor m_lineToCursorColor;//color of the last point of ipos to the cursor.
};
