/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file GLCommandFactory.h
 * @brief hLgR}h̃t@Ng[NXB
 */
#pragma once
#include <map>

class fugenDoc;
class MGCommandBase;

/// @class CGLCommandFactory Common/GLCommandFactory.h
///
/// hLgR}h̃t@Ng[NXB
class CGLCommandFactory
{
	typedef MGCommandBase* (*CreateCommandFunc)(fugenDoc* pDoc, UINT nCmdID);
	typedef std::map<UINT, CreateCommandFunc> CommandMap;
	typedef bool (*UpdateUIFunc)(fugenDoc* pDoc, UINT nCmdID);
	typedef std::map<UINT, UpdateUIFunc> UpdateUIMap;

	CommandMap m_commandFactoryMap; ///< RegisterCommand() Q
	UpdateUIMap m_uimap; ///< RegisterUpdateUI() Q

public:
	/// ftHgRXgN^[
	CGLCommandFactory();

	/// fXgN^[
	~CGLCommandFactory();

	/// R}hIuWFNg𐶐ł邩ۂeXgB
	/// @note Complexity O(1) ŎB
	bool QueryCommand(UINT nCmdID) const;

	/// R}h ID ƃhLg琶
	MGCommandBase* CreateCommand(fugenDoc* pDoc, UINT nCmdID) const;

	/// R}hɑΉ郁j[ACe̗LeXgɗpB
	bool IsEnabled(fugenDoc* pDoc, UINT nCmdID) const;

	void RegisterCommand(UINT nID, CreateCommandFunc pfn);
	void RegisterUpdateUI(UINT nID, UpdateUIFunc pfn);
};
