/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/**
 * Common/GLCommandFactory.h ̎B
 */
#include "stdafx.h"

#include "Common/GLCommandFactory.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ftHgRXgN^[
CGLCommandFactory::CGLCommandFactory(){
}

// fXgN^[
CGLCommandFactory::~CGLCommandFactory(){
}

void CGLCommandFactory::RegisterCommand(UINT nID, CreateCommandFunc pfn){
	m_commandFactoryMap[nID] = pfn;
}

void CGLCommandFactory::RegisterUpdateUI(UINT nID, UpdateUIFunc pfn){
	m_uimap[nID] = pfn;
}

// R}hIuWFNg𐶐ł邩ۂeXgB
// @note Complexity O(1) ŎB
bool CGLCommandFactory::QueryCommand(UINT nCmdID) const{
	// L[ nCmdID }bvɂ OK B
	return m_commandFactoryMap.count(nCmdID) == 1;
}

// R}h ID ƃhLgR}h𐶐io^ς̃\bhĂԁj
MGCommandBase* CGLCommandFactory::CreateCommand(fugenDoc* pDoc, UINT nCmdID)const{
	CommandMap::const_iterator i = m_commandFactoryMap.find(nCmdID);
	if(i == m_commandFactoryMap.end()){
		return nullptr;
	}

	// R}h֐|C^[𓾂B
	CreateCommandFunc pfnCreateCommand = i->second;
	ASSERT(pfnCreateCommand);

	// MGCommandBase  new ĕԂB
	return (*pfnCreateCommand)(pDoc, nCmdID);
}

// R}hɑΉ郁j[ACe̗LeXgɗpB
bool CGLCommandFactory::IsEnabled(fugenDoc* pDoc, UINT nCmdID)const{
	UpdateUIMap::const_iterator i = m_uimap.find(nCmdID);
	if(i == m_uimap.end()){
		// true: Ɏs\ƂB
		return true;
	}

	// ֐|C^[𓾂B
	UpdateUIFunc pfnUpdateUIFunc = i->second;
	// ki[Ăꍇ́AsȂB
	return pfnUpdateUIFunc ? (*pfnUpdateUIFunc)(pDoc, nCmdID) : false;
}
