/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(__MGCALC_SURFACE_H__)
#define __MGCALC_SURFACE_H__

class MGPlane;
class MGSBRep;
class MGRSBRep;
class MGSurface;
class MGFace;
class MGShell;

class MGBox;
class MGPosition;
class MGStraight;
class MGCurve;
class MGObject;

namespace mgcalc{

	// Creates a swept surface with two curves.
	std::unique_ptr<MGSurface> create_sweep_surface(
		const MGCurve& shape,     // shape curve
		const MGCurve& path       // path curve
		);
	// Creates a swept surface with a curve and a position.
	std::unique_ptr<MGSurface> create_sweep_surface(
		const MGCurve&    curve,  // a curve
		const MGPosition& pos     // degenerate point
		);

	// Create a planar face sorrounded by boundary.
	// If boundary does not make a loop, return 0.
	std::unique_ptr<MGFace> planar_face(const MGCurve& boundary);

	// Creates a planar face that has four vertices A, B, C, and D.
	//MGVector(B,A) makes u-direction and MGVector(D,A) makes v-direction of the plane.
	std::unique_ptr<MGFace> rectangular_face(
		const MGPosition& A,
		const MGPosition& B,
		const MGPosition& C,
		const MGPosition& D
	);
	
	// Creates a planar face that has four vertices corners[4].
	//Let A=corners[0], B=corners[1],..., then this is the same as the above.
	//MGVector(corners[1],corA) makes u-direction and MGVector(D,A) makes v-direction of the plane.
	std::unique_ptr<MGFace> rectangular_face(
		const MGPosition corners[4]
	);

	// Creates a shell shapes to box.
	std::unique_ptr<MGObject> shell_box(const MGBox& box);

	/**
	 *  @brief  gʂ̃x[Xʂ\Ȍ菬
	 *  @param  face 
	 *
	 *  limit() ł͂Ȃ part() gƁB
	 */
	std::unique_ptr<MGFace> shrink(const MGFace& face);

} // namespace mgcalc

#endif __MGCALC_SURFACE_H__
