/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

#if !defined(__MGCALC_RECT_H__)
#define __MGCALC_RECT_H__

#include <iosfwd>
#include <memory>
#include "mg/LBRep.h"
#include "mg/Plane.h"

class MGCurve;
class MGPlane;
class MGPosition;

namespace mgcalc{	
	/// class MGRect
	///
	/// `J[uNX
	class MGRect{
	public:
		MGRect();
		MGRect(const MGRect& other);
		MGPosition corner(int i) const;
		void clear(){m_polyline.reset();};

		/**
		 *  @brief  2R[i[^ċ`J[u𐶐
		 *  @param  plane  `镽ʂɕsȕ
		 *  @param  corner1  `̒_
		 *  @param  corner2  @a corner1 ̑Ίp̌̒_̃qg
		 *
		 *   @a corner2  @a corner1 ʂ @a plane ɕsȕʂ
		 *  ĂȂꍇA@a corner2 ͕sȕʂɖʒeA
		 *  ̓_ @a corner1 ̑Ίp̌̒_ƂȂB
		 */
		bool create_from_corner(
			const MGPlane&    plane,
			const MGPosition& corner1,
			const MGPosition& corner2
			);

		/**
		 *  @brief  SƂЂƂ̃R[i[^ċ`J[u𐶐
		 *  @param  plane  `镽ʂɕsȕ
		 *  @param  center  `̏dS
		 *  @param  corner  `̎n_
		 *
		 *   @a corner  @a center ʂ @a plane ɕsȕʂ
		 *  ĂȂꍇA@a corner ͕sȕʂɖʒeA
		 *  ̓_`1_ƂȂB
		 */
		bool create_from_center(
			const MGPlane&    plane,
			const MGPosition& center,
			const MGPosition& corner
			);

		/**
		 *  @brief  GbW{ƑΕӂɂ肻ȓ_w肵ċ`J[u𐶐
		 *  @param  es  GbW̎n_
		 *  @param  ee  GbW̏I_
		 *  @param  p   GbW̑Εӂɂ肻ȓ_
		 */
		bool create_from_edge(
			const MGPosition& es,
			const MGPosition& ee,
			const MGPosition& p
			);
		
		const MGCurve* curve() const;///< Get the pointer to m_polyline.
		void draw(mgSysGL& sgl) const;
		const MGPlane* plane() const;
		MGCurve* release();
		bool valid() const;

		friend std::ostream& operator<<(std::ostream& os, const MGRect& rect);

	private:
		std::unique_ptr<MGLBRep>  m_polyline;
		MGPlane m_plane;
	};

	// class MGRoundRect
	//
	// p̊ۂ܂`J[uNX
	class MGRoundRect{
	public:
		MGRoundRect();
		MGRoundRect(const MGRoundRect& other);
		const MGCurve* curve() const;///< Get the pointer to m_roundRect.
		void clear(){m_roundRect.reset();};

		/**
		 *  @brief  2R[i[^Ċp̊ۂ`J[u𐶐
		 *  @param  rect     `Ȑ
		 *  @param  through  p̉~ʏ̓_
		 *
		 *   @a corner2  @a corner1 ʂ @a plane ɕsȕʂ
		 *  ĂȂꍇA@a corner2 ͕sȕʂɖʒeA
		 *  ̓_ @a corner1 ̑Ίp̌̒_ƂȂB
		 *
		 *   @a through p̊ۂ݂włȂꍇÅ֐
		 *  ۂ݂̔a min(`̕ӂ̒) * 0.5 ƂČvZB
		 */
		bool create(
			const MGRect*     rect,
			const MGPosition& through
			);

		/**
		 *  @brief  2R[i[^Ċp̊ۂ`J[u𐶐
		 *  @param  rect     `Ȑ
		 *  @param  radius   ~ʂ̔a܂͉~Ȑ rho l
		 *
		 *  @a radius Ŋۂ݂ȂꍇÅ֐
		 *  ۂ݂̔a min(`̕ӂ̒) * 0.5 ƂČvZB
		 */
		bool create(
			const MGRect* rect,
			double        radius
			);
		
		void draw(mgSysGL& sgl) const;
		MGCurve* release();
		bool valid() const;

	private:
		std::unique_ptr<MGCurve>  m_roundRect;
	};

} // namespace mgcalc

#endif // __MGCALC_RECT_H__
